


 /**
 ******************************************************************************
 *
 * @file        main.c
 * @brief       The main Code's c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.04
 * @date        2024/10/04
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_MEM_DRV.h"
#include "MG32_USBD_Keyboard_API.h"
#include "MG32_RGB_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
extern void MCU_Init(void);

/* External variables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	    Main function in the project.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
int main(void)
{
    //==========================================
    //IC hardware initial (ChipInit_Wizard)
    MCU_Init();
    
    //=========================================
    //Main code loop
    while(1)
    {
        API_KB_Main();
        
        #if MG32_USBD_KEYBOARD_RGB_EN != API_RGB_DISABLE
            API_RGB_Main();
        #endif
        
        /*Sample Code*/
        if ( InFlag )                                 // Data size of "InLen" is already 
        { // To do..                                  // in the "InBuffer[]"    
           USB_Send_Data_To_PC( InLen , InBuffer );
			
           USB_Read_Data_Complete();                  // Do not remove
        }
    }
}     








